VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CWordTemplateProcessor"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const C_ERRORRAISE As Long = 2500

Private Enum ArmErr
    DBCnxFailed = C_ERRORRAISE + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = C_ERRORRAISE + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = C_ERRORRAISE + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = C_ERRORRAISE + 4
    PropertyNotSet = C_ERRORRAISE + 5
    SQLFailure = C_ERRORRAISE + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = C_ERRORRAISE + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = C_ERRORRAISE + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = C_ERRORRAISE + 9
    CompFncFailed = C_ERRORRAISE + 10           ' when component function fail
    GridLoadFailed = C_ERRORRAISE + 11          ' load function failed ... bad sql
    InvalidValue = C_ERRORRAISE + 12          ' load function failed ... bad sql
End Enum

Private Type tWORD_TEMPLATE_PICTURE
    BookmarkRefName As String
    FileName As String
End Type

Private Type tWORD_TEMPLATE_DATA
    BookmarkRefName As String
    ScreenName As String
    StoredProc As String
    Language As String
End Type

Private Type tWORD_TEMPLATE_TABLE
    BookmarkRefName As String
    ScreenName As String
    HeaderConstant As String
    StoredProc As String
    Language As String
    HeaderArray() As String
End Type

Private Type tWORD_TEMPLATE
    Data() As tWORD_TEMPLATE_DATA
    Tables() As tWORD_TEMPLATE_TABLE
    Pictures() As tWORD_TEMPLATE_PICTURE
End Type

Dim mo_TemplateDef As tWORD_TEMPLATE

#If LIVE = 1 Then
    Dim mo_Db As Object
    Dim mo_Word As Object   ' Word.Application
#Else
    Dim mo_Db As Object
    Dim mo_Word As Object   ' Word.Application
#End If

Public Property Set ArmDb(ByRef local_connection As Object)
    If Not (local_connection Is Nothing) Then
        Set mo_Db = local_connection
    End If
End Property

Public Function Init()

    On Error GoTo ErrorHandler
    
    ReDim mo_TemplateDef.Tables(0) As tWORD_TEMPLATE_TABLE
    ReDim mo_TemplateDef.Data(0) As tWORD_TEMPLATE_DATA
    ReDim mo_TemplateDef.Pictures(0) As tWORD_TEMPLATE_PICTURE
    
    ' Create Word Application
    Set mo_Word = CreateObject("Word.Application")
    mo_Word.Visible = False
    
    Init = True
    Exit Function
    
ErrorHandler:
    Call ErrorHandler("Init")
End Function

Public Sub Clear()
    Set mo_Word = Nothing
End Sub

Public Sub SavePDFAndClose(ByVal as_FileName As String)
#If LIVE = 1 Then
    Dim lo_Doc As Object  ' Word.Document
#Else
    Dim lo_Doc As Object  ' Word.Document
#End If
    
    On Error GoTo ErrorHandler
    
    Set lo_Doc = mo_Word.ActiveDocument
    
    If Len(as_FileName) > 0 Then
        Call lo_Doc.SaveAs(as_FileName, 17) ' JN -- WdSaveFormat.wdFormatPDF)
    End If
        
    Call lo_Doc.Close(False)
    
    mo_Word.NormalTemplate.Saved = True
    
    Call mo_Word.quit
    
    Set lo_Doc = Nothing
    Set mo_Word = Nothing
    
    Exit Sub
    
ErrorHandler:
    
    Set lo_Doc = Nothing
    Set mo_Word = Nothing
    
    Call ErrorHandler("SavePDFAndClose")
End Sub


Public Function AddNewData(ByVal as_BookmarkRefName As String, ByVal as_ScreenName As String, ByVal as_StoredProc As String, ByVal as_Language As String)
    
    Dim lo_TemplateData As tWORD_TEMPLATE_DATA
       
    On Error GoTo ErrorHandler
    
    lo_TemplateData.BookmarkRefName = as_BookmarkRefName
    lo_TemplateData.ScreenName = as_ScreenName
    lo_TemplateData.StoredProc = as_StoredProc
    lo_TemplateData.Language = as_Language
    
    ReDim Preserve mo_TemplateDef.Data(UBound(mo_TemplateDef.Data) + 1)
               
    mo_TemplateDef.Data(UBound(mo_TemplateDef.Data) - 1) = lo_TemplateData
    
    AddNewData = True
    Exit Function
    
ErrorHandler:
    Call ErrorHandler("AddNewData")
End Function

Public Function AddNewPicture(ByVal as_BookmarkRefName As String, ByVal as_FileName As String)
    
    Dim lo_TemplatePicture As tWORD_TEMPLATE_PICTURE
       
    On Error GoTo ErrorHandler
    
    lo_TemplatePicture.BookmarkRefName = as_BookmarkRefName
    lo_TemplatePicture.FileName = as_FileName
    
    ReDim Preserve mo_TemplateDef.Pictures(UBound(mo_TemplateDef.Pictures) + 1)
               
    mo_TemplateDef.Pictures(UBound(mo_TemplateDef.Pictures) - 1) = lo_TemplatePicture
    
    AddNewPicture = True
    Exit Function
    
ErrorHandler:
    Call ErrorHandler("AddNewPicture")
End Function

Public Function AddNewTable(ByVal as_BookmarkRefName As String, ByVal as_ScreenName As String, ByVal as_HeaderNames As String, ByVal as_StoredProc As String, ByVal as_Language As String)
    
    Dim lo_TemplateTable As tWORD_TEMPLATE_TABLE
       
    On Error GoTo ErrorHandler
    
    lo_TemplateTable.BookmarkRefName = as_BookmarkRefName
    lo_TemplateTable.ScreenName = as_ScreenName
    lo_TemplateTable.HeaderConstant = as_HeaderNames
    lo_TemplateTable.StoredProc = as_StoredProc
    lo_TemplateTable.Language = as_Language
             
    ReDim Preserve mo_TemplateDef.Tables(UBound(mo_TemplateDef.Tables) + 1)
    
    mo_TemplateDef.Tables(UBound(mo_TemplateDef.Tables) - 1) = lo_TemplateTable
    
    AddNewTable = True
    Exit Function
    
ErrorHandler:
    Call ErrorHandler("AddNewTable")
End Function

Public Function ProcessFile(ByVal as_filePath As String, Optional ab_Visible = True)
Dim ll_Index As Long

#If LIVE = 1 Then
    Dim lo_Doc As Object  ' Word.Document
    Dim lo_Range As Object
    Dim lo_InlineShape As Object
#Else
    Dim lo_Doc As Object  ' Word.Document
    Dim lo_Range As Object
    Dim lo_InlineShape As Object
#End If
   
    ProcessFile = False
    
    On Error GoTo ErrorHandler

    ' Open word document
    Set lo_Doc = mo_Word.Documents.Add(as_filePath)
        
    ' process tables
    For ll_Index = 0 To UBound(mo_TemplateDef.Tables) - 1
        Call FillTable(mo_TemplateDef.Tables(ll_Index), lo_Doc)
    Next
        
    ' process data
    For ll_Index = 0 To UBound(mo_TemplateDef.Data) - 1
        Call FillTemplateValues(lo_Doc, mo_TemplateDef.Data(ll_Index))
        Call FillTemplateLabels(lo_Doc, mo_TemplateDef.Data(ll_Index))
    Next
                  
    For ll_Index = 0 To UBound(mo_TemplateDef.Pictures) - 1
        Call FillPicture(lo_Doc, mo_TemplateDef.Pictures(ll_Index))
    Next
                  
    mo_Word.Visible = ab_Visible
                    
    Call lo_Doc.Activate
    
    Set lo_Doc = Nothing
    
    mo_Word.NormalTemplate.Saved = True
    
    ProcessFile = True
    Exit Function

ErrorHandler:
    lo_Doc.Close (False)
    
    Call ErrorHandler("ProcessFile")

End Function

#If LIVE = 1 Then
Private Function FillTable(ByRef ao_Table As tWORD_TEMPLATE_TABLE, ByRef ao_Doc As Object)
#Else
Private Function FillTable(ByRef ao_Table As tWORD_TEMPLATE_TABLE, ByRef ao_Doc As Object)
#End If
Dim ll_Cursor As Long
Dim ll_IndexCol As Long
Dim ll_IndexRow As Long
Dim lo_Table As Object
Dim ll_BookmarkIndex As Integer
Dim ls_ColumnName As String
Dim la_ColBookmarkName() As String
Dim ll_FormatIndex As Long
Dim ls_FormatInfo As String
Dim ls_ReplaceInfo As String

    On Error GoTo ErrHandler
    
    Set lo_Table = ao_Doc.bookmarks.Item(ao_Table.BookmarkRefName & "_T_" & ao_Table.HeaderConstant).Range.Tables(1)
    
    ll_Cursor = OpenSQLSafe(mo_Db, ao_Table.StoredProc)
    If ll_Cursor > 0 Then
        ll_IndexRow = 2
        
        ' init Columns names depending on bookmark names
        ReDim la_ColBookmarkName(lo_Table.Columns.Count)
        For ll_IndexCol = 1 To lo_Table.Columns.Count
            For ll_BookmarkIndex = 1 To lo_Table.Range.bookmarks.Count
                If InStr(lo_Table.Range.bookmarks.Item(ll_BookmarkIndex).Range, "Col" & ll_IndexCol) > 0 _
                    And lo_Table.Range.bookmarks.Item(ll_BookmarkIndex).Name <> ao_Table.BookmarkRefName & "_T_" & ao_Table.HeaderConstant Then
                    la_ColBookmarkName(ll_IndexCol) = lo_Table.Range.bookmarks.Item(ll_BookmarkIndex).Name
                    la_ColBookmarkName(ll_IndexCol) = Replace(la_ColBookmarkName(ll_IndexCol), ao_Table.BookmarkRefName & "_T_" & ao_Table.HeaderConstant & "_", "")
                    Exit For
                End If
            Next
        Next
        
        While Not mo_Db.EOF(ll_Cursor)
        
            If ll_IndexRow > 2 Then
                ' first row is auto available in template
                ' it is necessary to be able to format the table row in template
                lo_Table.Rows.Add
            End If
                       
            For ll_IndexCol = 1 To lo_Table.Columns.Count
            
                ll_FormatIndex = InStr(la_ColBookmarkName(ll_IndexCol), "__")
                
                If ll_FormatIndex > 0 Then
                    ls_FormatInfo = right(la_ColBookmarkName(ll_IndexCol), Len(la_ColBookmarkName(ll_IndexCol)) - ll_FormatIndex - 1)
                    ls_ReplaceInfo = Left(la_ColBookmarkName(ll_IndexCol), ll_FormatIndex - 1)
                Else
                    ls_FormatInfo = ""
                End If
                
                If mo_Db.GetFieldType(ll_Cursor, la_ColBookmarkName(ll_IndexCol)) = DBTYPE_DATE Then
                    If mo_Db.GetFields(ll_Cursor, la_ColBookmarkName(ll_IndexCol)) = 0 Then
                        lo_Table.Cell(ll_IndexRow, ll_IndexCol).Range.Text = ""
                    Else
                        lo_Table.Cell(ll_IndexRow, ll_IndexCol).Range.Text = Format(mo_Db.GetFields(ll_Cursor, la_ColBookmarkName(ll_IndexCol)), "dd\/mm\/yyyy")
                    End If
                    
                Else
                    If Left(ls_FormatInfo, 1) = "F" Then
                        lo_Table.Cell(ll_IndexRow, ll_IndexCol).Range.Text = DblToScreen(mo_Db.GetFields(ll_Cursor, ls_ReplaceInfo), right(ls_FormatInfo, 1))
                    Else
                        lo_Table.Cell(ll_IndexRow, ll_IndexCol).Range.Text = mo_Db.GetFields(ll_Cursor, la_ColBookmarkName(ll_IndexCol))
                    End If
                End If
            Next
            ll_IndexRow = ll_IndexRow + 1
            Call mo_Db.Next(ll_Cursor)
        Wend
    End If
    
    ao_Doc.bookmarks.Item(ao_Table.BookmarkRefName & "_T_" & ao_Table.HeaderConstant).Delete
    
    Call mo_Db.Close(ll_Cursor)
    
    Exit Function
    
ErrHandler:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
    End If
    Call ErrorHandler("FillTable")
End Function

Public Function IsEmpty(aa_array() As String) As Long
    ' Trap error if array is empty
    IsEmpty = True
    On Error Resume Next
    IsEmpty = Not UBound(aa_array) > 0
End Function

#If LIVE = 1 Then
Private Sub FillTemplateLabels(ByRef ao_Doc As Object, ByRef ao_TmpData As tWORD_TEMPLATE_DATA)
#Else
Private Sub FillTemplateLabels(ByRef ao_Doc As Object, ByRef ao_TmpData As tWORD_TEMPLATE_DATA)
#End If

#If LIVE = 1 Then
    Dim lo_Range As Object
#Else
    Dim lo_Range As Object
#End If

Dim li_Idx, li_Idx2 As Integer
Dim li_Label As Integer      ' A label idx
Dim ls_Request As String
Dim lc_Labels As Long
Dim li_LabelStartPos As Integer
Dim ls_Label As String
    
    On Error GoTo ErrHandler

    ls_Request = "exec screen_csts '" & ao_TmpData.ScreenName & "','" & ao_TmpData.Language & "'"
    lc_Labels = OpenSQLSafe(mo_Db, ls_Request)
       
    ' Iterate the container for loading the label of each element which has defined a tag
    For li_Idx = ao_Doc.bookmarks.Count To 1 Step -1
    
        li_LabelStartPos = InStr(1, ao_Doc.bookmarks.Item(li_Idx).Name, ao_TmpData.BookmarkRefName & "_", vbTextCompare)
        If li_LabelStartPos = 1 Then
            ls_Label = Replace(ao_Doc.bookmarks.Item(li_Idx).Name, ao_TmpData.BookmarkRefName & "_", "", , , vbTextCompare)
            li_Label = mo_Db.Find(lc_Labels, "FIELD_NAME", ls_Label, , 1)
            If li_Label >= 0 Then
                Set lo_Range = ao_Doc.bookmarks.Item(li_Idx).Range
                           
                lo_Range.Text = mo_Db.GetFields(lc_Labels, "LOCAL_TEXT")
                            
                Set lo_Range = Nothing
                'ao_Doc.Bookmarks.Item(li_Idx).Delete
            Else
                ' try to fill table header names
                 For li_Idx2 = 0 To UBound(mo_TemplateDef.Tables) - 1
                    If ao_TmpData.ScreenName = mo_TemplateDef.Tables(li_Idx2).ScreenName And ao_TmpData.Language = mo_TemplateDef.Tables(li_Idx2).Language Then
                        li_LabelStartPos = InStr(1, ao_Doc.bookmarks.Item(li_Idx).Name, mo_TemplateDef.Tables(li_Idx2).BookmarkRefName & "_T_" & mo_TemplateDef.Tables(li_Idx2).HeaderConstant & "_", vbTextCompare)
                        If li_LabelStartPos = 1 Then
                            ls_Label = Replace(ao_Doc.bookmarks.Item(li_Idx).Name, mo_TemplateDef.Tables(li_Idx2).BookmarkRefName & "_T_", "", , , vbTextCompare)
                                            
                            If InStr(ls_Label, "__") > 0 Then
                                ls_Label = Left(ls_Label, InStr(ls_Label, "__") - 1)
                            End If

                            li_Label = mo_Db.Find(lc_Labels, "FIELD_NAME", ls_Label, , 1)
                            If li_Label >= 0 Then
                                Set lo_Range = ao_Doc.bookmarks.Item(li_Idx).Range
                                           
                                lo_Range.Text = mo_Db.GetFields(lc_Labels, "LOCAL_TEXT")
                                            
                                Set lo_Range = Nothing
                                Exit For
                            End If
                        End If
                    End If
                Next
                                    
            End If
        End If
    Next
       
    Call mo_Db.Close(lc_Labels)
    Exit Sub
    
ErrHandler:
    If lc_Labels > 0 Then
        Call mo_Db.Close(lc_Labels)
    End If
    Call ErrorHandler("FillTemplateLabels")
End Sub

#If LIVE = 1 Then
Private Sub FillTemplateValues(ByRef ao_Doc As Object, ByRef ao_TmpData As tWORD_TEMPLATE_DATA)
#Else
Private Sub FillTemplateValues(ByRef ao_Doc As Object, ByRef ao_TmpData As tWORD_TEMPLATE_DATA)
#End If

On Error GoTo ErrHandler

#If LIVE = 1 Then
    Dim lo_Range As Object
#Else
    Dim lo_Range As Object
#End If

Dim li_Idx As Integer
Dim li_Label As Integer      ' A label idx
Dim lc_Labels As Long
Dim li_LabelStartPos As Integer
Dim ls_Label As String
Dim ll_FormatIndex As Long
Dim ls_FormatInfo As String
Dim ls_ReplaceInfo As String
    
    lc_Labels = OpenSQLSafe(mo_Db, ao_TmpData.StoredProc)
       
    ' Iterate the container for loading the value for every element which has defined a bookmark
    For li_Idx = ao_Doc.bookmarks.Count To 1 Step -1
        
        li_LabelStartPos = InStr(1, ao_Doc.bookmarks.Item(li_Idx).Name, ao_TmpData.BookmarkRefName & "_", vbTextCompare)
        If li_LabelStartPos = 1 Then
            ls_Label = Replace(ao_Doc.bookmarks.Item(li_Idx).Name, ao_TmpData.BookmarkRefName & "_", "", , , vbTextCompare)
            
            ll_FormatIndex = InStr(ls_Label, "__")
            
            If ll_FormatIndex > 0 Then
                ls_FormatInfo = right(ls_Label, Len(ls_Label) - ll_FormatIndex - 1)
                ls_ReplaceInfo = Left(ls_Label, ll_FormatIndex - 1)
            Else
                ls_FormatInfo = ""
                ls_ReplaceInfo = ls_Label
            End If
            
            li_Label = mo_Db.GetFieldIndex(lc_Labels, ls_ReplaceInfo)
            If li_Label >= 0 Then
                Set lo_Range = ao_Doc.bookmarks.Item(li_Idx).Range
                           
                If mo_Db.GetFieldType(lc_Labels, ls_ReplaceInfo) = DBTYPE_DATE Then
                    If mo_Db.GetFields(lc_Labels, ls_ReplaceInfo) = 0 Then
                        lo_Range.Text = ""
                    Else
                        lo_Range.Text = Format(mo_Db.GetFields(lc_Labels, ls_ReplaceInfo), "dd\/mm\/yyyy")
                    End If
                    
                Else
                    If Left(ls_FormatInfo, 1) = "F" Then
                        lo_Range.Text = DblToScreen(mo_Db.GetFields(lc_Labels, ls_ReplaceInfo), right(ls_FormatInfo, 1))
                    Else
                        lo_Range.Text = mo_Db.GetFields(lc_Labels, ls_ReplaceInfo)
                    End If
                End If
                            
                Set lo_Range = Nothing
                
            End If
        End If
    Next
    
    Call mo_Db.Close(lc_Labels)
    Exit Sub
ErrHandler:
    If lc_Labels > 0 Then
        Call mo_Db.Close(lc_Labels)
    End If
    Call ErrorHandler("FillTemplateValues")
End Sub

#If LIVE = 1 Then
Private Sub FillPicture(ByRef ao_Doc As Object, ByRef ao_TmpPicture As tWORD_TEMPLATE_PICTURE)

#Else
Private Sub FillPicture(ByRef ao_Doc As Object, ByRef ao_TmpPicture As tWORD_TEMPLATE_PICTURE)
#End If

On Error GoTo ErrHandler

#If LIVE = 1 Then
    Dim lo_Range As Object
    Dim lo_Shape As Object
#Else
    Dim lo_Range As Object
    Dim lo_Shape As Object
#End If

Dim lf_coef1 As Double
Dim lf_coef2 As Double
Dim lf_coef As Double
Dim li_Idx As Integer
           
    ' Iterate the container for loading the value for every element which has defined a bookmark
    For li_Idx = ao_Doc.bookmarks.Count To 1 Step -1
        
        If ao_Doc.bookmarks.Item(li_Idx).Name = ao_TmpPicture.BookmarkRefName Then
            Set lo_Range = ao_Doc.bookmarks.Item(li_Idx).Range
            lo_Range.Text = ""
            Set lo_Shape = lo_Range.InlineShapes.AddPicture(ao_TmpPicture.FileName, False, True)
            
            lf_coef = 1
            
            lf_coef1 = lo_Shape.Width / 100
            lf_coef2 = lo_Shape.Height / 100
            
            If lf_coef1 > lf_coef2 Then
                lf_coef = lf_coef1
            Else
                lf_coef = lf_coef2
            End If
            
            If lf_coef > 0 Then
                lo_Shape.Width = lo_Shape.Width / lf_coef
                lo_Shape.Height = lo_Shape.Height / lf_coef
            End If
            
            Exit For
        End If
    Next
    
    Set lo_Range = Nothing
                
    Exit Sub
ErrHandler:
    Call ErrorHandler("FillPicture")
End Sub


' Return the result of a SQL request
' Convert SQL runtime errors and process errors to VB Error
#If LIVE = 1 Then
Private Function OpenSQLSafe(ByVal ao_Db As Object, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#Else
Private Function OpenSQLSafe(ByVal ao_Db As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#End If

On Error GoTo ErrHandler

    Dim lc_Data As Long
    lc_Data = ao_Db.OpenSQL(as_Request)
    
    If lc_Data = 0 Then
        Err.Raise ArmErr.SQLFailure, "SQL : " & as_Request, Join(ao_Db.SQLErrorCodes, SEP2) & SEP1 & Join(ao_Db.SQLErrorMessages, SEP2)
    End If
    
    If al_RowExpectedCount <> -1 Then
        ' Then check the rowcount
        If ao_Db.RowCount(lc_Data) <> al_RowExpectedCount Then
            Err.Raise ArmErr.SQLBadRowExpectedCount, "SQL : " & as_Request, al_RowExpectedCount & "<>" & ao_Db.RowCount(lc_Data)
        End If
    End If

    OpenSQLSafe = lc_Data
    Exit Function

ErrHandler:
    Call ErrorHandler("OpenSQLSafe")
End Function

Public Function DblToScreen(ByVal ad_Value As Double, Optional ByVal al_Decimal As Long = 2) As String
On Error GoTo ErrHandler

    If al_Decimal = 0 Then
      DblToScreen = Format(Round(ad_Value, al_Decimal), "0")
    Else
      DblToScreen = Format(Round(ad_Value, al_Decimal), "0." & String(al_Decimal, "0"))
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("DblToScreen")
End Function

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
    Err.Raise Err.Number, "CWordTempkateProcessor" & "::" & as_Fct & SEP1 & Err.Source, Err.Description
End Sub

